#define _INC_OLE
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef _INC_OLE

#include <stdio.h>
#include <stdarg.h>

#define _WIN32_WINNT 0x0400
#define ISDLL
#include "ihook.h"

#pragma data_seg(".JOE")
DWORD server = 0L;
DWORD mousestate = 0L;

int screenw = 0L;
int screenh = 0L;
#pragma data_seg()
#pragma comment(linker, "/section:.JOE,rws")

/*
#define SHARED __attribute__((section(".shr"), shared))

DWORD server SHARED = 0L;
DWORD mousestate SHARED = 0L;

int screenw SHARED = 0L;
int screenh SHARED = 0L;
*/
HHOOK mousehook = 0L;
HHOOK keyhook = 0L;

HINSTANCE inst = (HINSTANCE)0x10000000;
UINT msgmouse = WM_HOOK_MOUSE;
UINT msgkey = WM_HOOK_KEYBOARD;
//HANDLE retevent = GetEvent();

static LRESULT CALLBACK LowMouseHook(UINT nCode, WPARAM wParam, LPARAM lParam);
static LRESULT CALLBACK LowKeyboardHook(UINT nCode, WPARAM wParam, LPARAM lParam);

//static void iLog(char *fmt,...);

BOOL APIENTRY DllMain(HINSTANCE hinstDLL, DWORD fdwReason, LPVOID lpvReserved)
{
	//MessageBox(NULL,"dll attach","info",MB_OK);	// test
	//iLog("dll attach");

    switch (fdwReason)
    {
        case DLL_PROCESS_ATTACH:
        	inst = hinstDLL;
        	inst = (HINSTANCE)0x10000000; // doesn't reach this point !!!!
        	return TRUE;
            break;

        case DLL_PROCESS_DETACH:
        	ResetInputHooks(server);
        	return TRUE;
            break;

        case DLL_THREAD_ATTACH: break;
        case DLL_THREAD_DETACH: break;
    }
    return TRUE; // succesful
}

DLL_EXPORT int SetInputHooks(DWORD thid,int ismouse,int iskey)
{
	//MessageBox(thid,"setihook","info",MB_OK);	// test
	//iLog("setihook");

	if (server) return 0L;
	int count = 0;
	if (!ismouse && !iskey) return 0;

	HDC dc = CreateDC("DISPLAY","DISPLAY",NULL,NULL);
	screenw = GetDeviceCaps(dc,HORZRES)-1;
	screenh = GetDeviceCaps(dc,VERTRES)-1;
	DeleteDC(dc);

	if (ismouse)
	{
		mousehook = SetWindowsHookEx(WH_MOUSE_LL,(HOOKPROC)LowMouseHook,inst,0);
		if (mousehook) count++;
	}

	if (iskey)
	{
		keyhook = SetWindowsHookEx(WH_KEYBOARD_LL,(HOOKPROC)LowKeyboardHook,inst,0);
		if (keyhook) count++;
	}

	if (count)
	{
		server = thid;
		return 1;
	}

	return 0;
}

DLL_EXPORT int ResetInputHooks(DWORD thid)
{
	if (!thid || !server || thid!=server) return 0;
	int count = 0;

	if (mousehook)
		if (UnhookWindowsHookEx(mousehook))
			count++;

	if (keyhook)
		if (UnhookWindowsHookEx(keyhook))
			count++;

	if (count)
	{
		server = 0L;
		return 1;
	}

	return 0;
}

static LRESULT CALLBACK LowMouseHook(UINT code, WPARAM wparam, LPARAM lparam)
{

	if(code < 0)
	{
		CallNextHookEx(mousehook, code, wparam, lparam);
		return 0;
	}

	if (code == HC_ACTION)
	{
		MSLLHOOKSTRUCT *hs = (MSLLHOOKSTRUCT*)lparam;

		int i;

		for (i=0;mmsg[i].msg!=0L;i++)
			if (mmsg[i].msg==wparam)
			{
				mousestate |= mmsg[i].flagset;
				mousestate &= ~mmsg[i].flagclr;
				break;
			}

		WPARAM wp = mousestate ;

		// add wheel
		if (wparam==WM_MOUSEWHEEL)
			if (hs->mouseData&0xFF000000) wp|=MWHEELDOWN;
				else wp|=MWHEELUP;

		// filter position

		if (hs->pt.x<0) hs->pt.x = 0;
		if (hs->pt.y<0) hs->pt.y = 0;

		if (hs->pt.x>screenw) hs->pt.x = screenw;
		if (hs->pt.y>screenh) hs->pt.y = screenh;

		// end filter

		LPARAM lp = MAKELPARAM(hs->pt.x,hs->pt.y);
//		LPARAM lp = hs->time;
		wp = hs->time;

//		PostThreadMessage(server,msgmouse,wp,lparam);
		PostThreadMessage(server,msgmouse,wp,lp);
	}

	return CallNextHookEx(mousehook, code, wparam, lparam);

}

/////////////// keyboard ///////////////////

static LRESULT CALLBACK LowKeyboardHook(UINT code, WPARAM wparam, LPARAM lparam)
{
	if(code < 0)
	{
		CallNextHookEx(keyhook, code, wparam, lparam);
		return 0;
	}

	if (code == HC_ACTION)
	{
		KBDLLHOOKSTRUCT *hs = (KBDLLHOOKSTRUCT*)lparam;

		WPARAM wp = hs->vkCode;
		wp |= (((WPARAM)(hs->scanCode&0xFFFF))<<16);
		if (!(hs->flags&LLKHF_UP)) wp |= KDOWN;

		LPARAM lp = 0;
		int i = 0;

		for (i=0;kmsg[i].vk!=0L;i++)
		{
			if (GetKeyState(kmsg[i].vk)&kmsg[i].flag) lp|=kmsg[i].code;
			if (kmsg[i].vk==hs->vkCode)
			{
				if (wp&KDOWN) lp|=kmsg[i].code;
				else if (kmsg[i].flag==0x80) lp&=~kmsg[i].code;
			}
		}


//		SetEvent(retevent);
		PostThreadMessage(server,msgkey,wp,lp);
//		PostMessage(server,msgkey,wp,lp);
	}

	return CallNextHookEx(keyhook, code, wparam, lparam);
}

