#define _INC_OLE
#include <windows.h>
#undef _INC_OLE
#include <windowsx.h>
#include <commctrl.h>
#include <stdio.h>

#include "resource.h"
#include "ihook.h"

#define WM_WORK			WM_USER+1
#define N	1

HANDLE event[2];	// start-stop
HWND wnd;
HINSTANCE inst;
HANDLE th[N];
DWORD thid[N];

BOOL CALLBACK DialogMainFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam);
LRESULT CALLBACK WindowViewProcedure(HWND w, UINT msg, WPARAM wParam, LPARAM lParam);
void Exit();
void Init();
void Log(char *fmt,...);
void OnStart();
void OnWork();
void OnStop();
void OnStop2();


DWORD WINAPI mthread(VOID *lp)
{
	DWORD id = GetCurrentThreadId();

	MSG msg;
	BOOL ret;

	int play = 0;
	int hook = 0;
	
	while(1)
	{
//		Log("begin MsgWaitForMultipleObjects");
		switch (MsgWaitForMultipleObjects(1,&event[play],FALSE,INFINITE,QS_POSTMESSAGE|QS_ALLINPUT))
		{
			case WAIT_OBJECT_0:
				if (!play)
				{
					play = 1;
					hook = SetInputHooks(id,1,1);
					Log("*-- %ld event - start hook=%d",id,hook);
	
					ret = PeekMessage(&msg,NULL,WM_USER,WM_USER+20,PM_NOREMOVE);
				}
				else
				{
					Log("--* %ld event - exit",id);
					ResetInputHooks(id);					
					ExitThread(0);
				}
				break;
			case WAIT_OBJECT_0+1:
				ret = GetMessage(&msg,NULL,WM_USER,WM_USER+100);

				if (ret)
					switch (msg.message)
					{
						case WM_WORK:
							Log("-*- %ld WM_WORK",id);
							break;
						case WM_HOOK_MOUSE:
						{
							short x = LOWORD(msg.lParam);
							short y = HIWORD(msg.lParam);

							Log("-*- %ld mouse: %d x=%d y=%d",id,msg.wParam,x,y);
						}
						break;
						case WM_HOOK_KEYBOARD:
						break;
						
					}
					
				break;
		}
	}

	return 0L;
}


int APIENTRY WinMain(HINSTANCE hinst,HINSTANCE prev,LPSTR cmdlime,int cmdshow)
{
	inst = hinst;
	event[0] = CreateEvent(NULL,TRUE,FALSE,NULL);
	event[1] = CreateEvent(NULL,TRUE,FALSE,NULL);

//	InitCommonControls();
	DialogBox(hinst,MAKEINTRESOURCE(DLG_MAIN),NULL,(DLGPROC)DialogMainFunc);

	CloseHandle(event[0]);
	CloseHandle(event[1]);
	
	return 0;
}

BOOL CALLBACK DialogMainFunc(HWND hwndDlg, UINT msg, WPARAM wParam, LPARAM lParam)
{
	switch (msg)
	{
		case WM_INITDIALOG:
			wnd = hwndDlg;
			Init();
			return TRUE;
		case WM_COMMAND:
			switch (LOWORD(wParam))
			{
				case IDC_START: OnStart(); break;
				case IDC_WORK: OnWork(); break;
				case IDC_STOP: OnStop(); break;
				case IDC_STOP2: OnStop2(); break;
			}
			break;
		case WM_CLOSE: Exit(); return TRUE;
	}

	return FALSE;
}

void Init()
{
	int i;
	for (i=0;i<N;i++) 
	{
		thid[i] = 0L;
		th[i] = NULL;
	}
}

void Exit()
{
	EndDialog(wnd,0);
}

void Log(char *fmt,...)
{
	char buf[100];
	va_list vl;

	va_start(vl,fmt);
	int n = SendDlgItemMessage(wnd,IDC_LOG,LB_GETCOUNT,0L,0L);
	if (n>150) SendDlgItemMessage(wnd,IDC_LOG,LB_DELETESTRING,0L,0L);
	_vsnprintf(buf,sizeof(buf),fmt,vl);
	va_end(vl);
	int p = SendDlgItemMessage(wnd,IDC_LOG,LB_ADDSTRING,0L,(LPARAM)buf);
	SendDlgItemMessage(wnd,IDC_LOG,LB_SETTOPINDEX,p,0);

}

void OnStart()
{
	int i;
	
	for (i=0;i<N;i++)
	{
		th[i] = CreateThread(NULL,0L,mthread,NULL,0L,&thid[i]);
		Log("*-- %ld start",thid[i]);
	}

	Sleep(500);
	SetEvent(event[0]);
	
}

void OnWork()
{
	int i;
	for (i=0;i<N;i++) PostThreadMessage(thid[i],WM_WORK,0,0);
}

void OnStop()
{
	SetEvent(event[1]);
	Log("SET EVENT1");
}

void OnStop2()
{
	int i;
	HANDLE ob[N];
	int n = 0;
	for (i=0;i<N;i++)	
		if (th[i]) ob[n++]=th[i];

	DWORD r = WaitForMultipleObjects(n,ob,TRUE,1000);
	
	Log("ret=%ld err=%ld",r,GetLastError());
	Log("WAIT_OBJECT_0=%d WAIT_FAILED=%ld WAIT_ABANDONED_0=%d WAIT_TIMEOUT=%ld",WAIT_OBJECT_0,WAIT_FAILED,WAIT_ABANDONED_0,WAIT_TIMEOUT);
		
	for (i=0;i<N;i++) CloseHandle(th[i]);
}
