#ifndef _INPUT_DEFS_
#define _INPUT_DEFS_

#define MNONE	0x00
#define BTNL	0x01
#define BTNR	0x02
#define BTNM	0x04
#define MWHEELUP	0x18
#define MWHEELDOWN	0x10

typedef struct
{
	UINT msg;
	WORD flagset;
	WORD flagclr;
}mouse_msgs;

mouse_msgs mmsg[] =	// keep as state
{
	{WM_MOUSEMOVE,MNONE,MNONE},
	{WM_LBUTTONDOWN,BTNL,MNONE},
	{WM_RBUTTONDOWN,BTNR,MNONE},
	{WM_MBUTTONDOWN,BTNM,MNONE},
	{WM_LBUTTONUP,MNONE,BTNL},
	{WM_RBUTTONUP,MNONE,BTNR},
	{WM_MBUTTONUP,MNONE,BTNM},
//	{WM_MOUSEWHEEL,MNONE,MNONE},

	{0L,0L,0L}
};

#define KDOWN	0x0100

#define KLSHIFT		0x0001
#define KRSHIFT		0x0002
#define KLCONTROL	0x0040
#define KRCONTROL	0x0080
#define KLMENU		0x0100
#define KRMENU		0x0200
#define KNUMLOCK	0x0400
#define KCAPSLOCK	0x0800
#define KSCROLL		0x1000
#define KLWIN		0x2000
#define KRWIN		0x4000
#define KAPPS		0x8000

typedef struct
{
	BYTE vk;
	SHORT flag;
	DWORD code;
}key_msgs;

key_msgs kmsg[] =
{
	{VK_LSHIFT,0x80,KLSHIFT},
	{VK_RSHIFT,0x80,KRSHIFT},
	{VK_LCONTROL,0x80,KLCONTROL},
	{VK_RCONTROL,0x80,KRCONTROL},
	{VK_LMENU,0x80,KLMENU},
	{VK_RMENU,0x80,KRMENU},
	{VK_NUMLOCK,0x01,KNUMLOCK},
	{VK_CAPITAL,0x01,KCAPSLOCK},
	{VK_SCROLL,0x01,KSCROLL},
	{VK_LWIN,0x80,KLWIN},
	{VK_RWIN,0x80,KRWIN},
	{VK_APPS,0x80,KAPPS},

	{0,0,0L}
};

#endif

