#define _INC_OLE
#define WIN32_LEAN_AND_MEAN
#include <windows.h>
#undef _INC_OLE

#include <stdio.h>

#include "ihook.h"


#define WM_WORK			WM_USER+1
#define N	1

HANDLE event[2];	// start-stop

DWORD WINAPI mthread(VOID *lp)
{
	DWORD id = GetCurrentThreadId();

	MSG msg;
	BOOL ret;

	int play = 0;
	int hook = 0;
	
	while(1)
	{
//		Log("begin MsgWaitForMultipleObjects");
		switch (MsgWaitForMultipleObjects(1,&event[play],FALSE,INFINITE,QS_POSTMESSAGE|QS_ALLINPUT))
		{
			case WAIT_OBJECT_0:
				if (!play)
				{
					play = 1;
					hook = SetInputHooks(id,1,1);
					printf("*-- %ld event - start hook=%d\n",id,hook);
	
					ret = PeekMessage(&msg,NULL,WM_USER,WM_USER+20,PM_NOREMOVE);
				}
				else
				{
					printf("--* %ld event - exit\n",id);
					ResetInputHooks(id);					
					ExitThread(0);
				}
				break;
			case WAIT_OBJECT_0+1:
				ret = GetMessage(&msg,NULL,WM_USER,WM_USER+100);

				if (ret)
					switch (msg.message)
					{
						case WM_WORK:
							printf("-*- %ld WM_WORK\n",id);
							break;
						case WM_HOOK_MOUSE:
						{
							short x = LOWORD(msg.lParam);
							short y = HIWORD(msg.lParam);

							printf("-*- %ld mouse: %d x=%d y=%d\n",id,msg.wParam,x,y);
						}
						break;
						case WM_HOOK_KEYBOARD:
						break;
						
					}
					
				break;
		}
	}

	return 0L;
}


int main()
{
	HANDLE th[N];
	DWORD thid[N];
	int i;

	event[0] = CreateEvent(NULL,TRUE,FALSE,NULL);
	event[1] = CreateEvent(NULL,TRUE,FALSE,NULL);

	for (i=0;i<N;i++) 
	{
		th[i] = NULL;
		thid[i] = (DWORD)-1;
	}

	for (i=0;i<N;i++)
	{
		th[i] = CreateThread(NULL,0L,mthread,NULL,0L,&thid[i]);
		printf("*-- %ld start\n",thid[i]);
	}

	Sleep(500);
	SetEvent(event[0]);
	Sleep(500);	
	
	for (i=0;i<N;i++) PostThreadMessage(thid[i],WM_WORK,0,0);
	for (i=0;i<N;i++) PostThreadMessage(thid[i],WM_WORK,0,0);
	Sleep(500);
	SetEvent(event[1]);
	printf("SET EVENT1\n");
	Sleep(500);

	HANDLE ob[N];
	int n = 0;
	for (i=0;i<N;i++)	
		if (th[i]) ob[n++]=th[i];

	DWORD r = WaitForMultipleObjects(n,ob,TRUE,1000);
	
	printf("ret=%ld err=%ld\n",r,GetLastError());
	printf("WAIT_OBJECT_0=%d WAIT_FAILED=%ld WAIT_ABANDONED_0=%d WAIT_TIMEOUT=%ld\n",WAIT_OBJECT_0,WAIT_FAILED,WAIT_ABANDONED_0,WAIT_TIMEOUT);

	for (i=0;i<N;i++) CloseHandle(th[i]);
	
	CloseHandle(event);
	return 0;
}

